﻿using System.Web.Mvc;

namespace MVC_App.Validation
{
	public class ModelStateErrorTracker : IErrorTracker
	{
		public ModelStateErrorTracker(string prefix, ModelStateDictionary modelState)
		{
			_prefix = prefix;
			_modelState = modelState;
		}

		private readonly string _prefix;
		private readonly ModelStateDictionary _modelState;

		public IErrorTracker Descend(string postfix)
		{
			return new ModelStateErrorTracker(
				string.IsNullOrEmpty(_prefix) ? postfix : _prefix + "." + postfix,
				_modelState);
		}

		public IErrorTracker DescendIndex(int index)
		{
			return new ModelStateErrorTracker(
				_prefix + "[" + index + "]",
				_modelState);
		}

		public void Error(string name, string message)
		{
			_modelState.AddModelError(_prefix + "." + name, string.Format(message, name));
		}
	}
}